/*******************  playVideo.js , merge => liveview.js ****************/

var url = "../dms.jpg"; // url to load image from
var urlnull = "../dmsnull2.jpg"; // url to load null image from
var urlA = "../dms_A.jpg"; // url to load image from
var urlB = "../dms_B.jpg"; // url to load image from
var dmsStatus = "A";
var imgPowerMode = "ON";

if (!location.hostname) {
    url = "http://" + location.hostname + "/dms.jpg";
}

var dmsimg;
var refreshInterval = 60; // in ms
var playVideores = 0;
var plyavideoPowerStatusCnt = 0;
var dmsimg;

function playVideo() {
    playJpegVideo();
}

function stopJpegVideo() {
    dmsimg = document.getElementById("dmsloader");
    dmsimg.onerror = function () {};
    dmsimg.onload = function () {};
}

function playJpegVideo() {

    dmsimg = document.getElementById("dmsloader");

    dmsimg.onerror = function () {
        refresh();
    };

    dmsimg.onload = function () {
        setTimeout("refresh()", refreshInterval);
    };

    dmsimg.onerror = function () {
        console.log("lums_mjpgipc - img.onerror : " + dmsStatus);
        if (dmsStatus == "A") {
            dmsimg.src = urlB + "?t=" + new Date().getTime();
        } else {
            dmsimg.src = urlA + "?t=" + new Date().getTime();
        }
    };

    updatePowerStatus2jpg();
    refresh();
}

function stopJpegVideoFull() {
    dmsimg = document.getElementById("dmsloaderFull");
    dmsimg.onerror = function () {};
    dmsimg.onload = function () {};
}

function playJpegVideoFull() {

    dmsimg = document.getElementById("dmsloaderFull");

    dmsimg.onerror = function () {
        refresh();
    };

    dmsimg.onload = function () {
        setTimeout("refresh()", refreshInterval);
    };

    dmsimg.onerror = function () {
        console.log("lums_mjpgipc - img.onerror : " + dmsStatus);
        if (dmsStatus == "A") {
            dmsimg.src = urlB + "?t=" + new Date().getTime();
        } else {
            dmsimg.src = urlA + "?t=" + new Date().getTime();
        }
    };

    updatePowerStatus2jpg();
    refresh();
}

function isJSON(body) {
    if (!body) return false;
    if ('string' == typeof body) return false;
    if ('function' == typeof body.pipe) return false;
    //if (Buffer.isBuffer(body)) return false;
    return true;
}

function updatePowerStatus2jpg() {
    var param = {};
    var cjsonstatus = "NG";

    $.ajax({
        url: "/powerModeInq",
        type: "POST",
        dataType: "json",
        contentType: "application/json",
        data: JSON.stringify(param),
        scriptCharset: "utf-8",
        timeout: 20 * 1000, // milliseconds
        error: function (xhr) {
            url = "../dmsnull2.jpg";
        },
        success: function (response) {
            if (isJSON(response) == true) {
                if (response.STATUS == "NG") {
                    cjsonstatus = "NG";
                } else {
                    cjsonstatus = "OK";
                    if (response.POWERMODE == "ON") {
                        imgPowerMode = "ON";
                    } else {
                        imgPowerMode = "OFF";
                    }
                }
            } else {
                cjsonstatus = "NG";
            }
        },
    });
}

function refresh() {
    var param = {};
    var cjsonstatus = "NG";

    if (plyavideoPowerStatusCnt > 50) {
        updatePowerStatus2jpg();
        plyavideoPowerStatusCnt = 0;
    } else {
        plyavideoPowerStatusCnt++;
    }

    if (cameraSettings.Power == "on") {
        $.ajax({
            url: "/en_dms_A",
            type: "POST",
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify(param),
            scriptCharset: "utf-8",
            timeout: 20 * 1000, // milliseconds
            error: function (xhr) {},
            success: function (response) {
                if (isJSON(response) == true) {
                    dmsStatus = response.DMSJPG;
                    if (response.DMSJPG == "A") {
                        dmsimg.src = urlA + "?t=" + new Date().getTime();
                    } else {
                        dmsimg.src = urlB + "?t=" + new Date().getTime();
                    }
                } else {
                    cjsonstatus = "NG";
                }
            },
        });
    }
}
/****************************** playVideo.js end ***************************************/

function liveviewOnload() {
    ToCtrlHome();
    setVideoScreen();
}

function ToCtrlSetting() {
    document.getElementById("Div_CtrlHome").style.display = "none";
    document.getElementById("Div_CtrlSetting").style.display = "block";
}

function ToCtrlHome() {
    if (cameraSettings.ViewerMode == 0 || cameraSettings.ViewerMode == 1) {
        document.getElementById("Div_CtrlHome").style.display = "block";
    } else {
        document.getElementById("Div_CtrlHome").style.display = "none";
    }
    document.getElementById("Div_CtrlSetting").style.display = "none";
}

function setVideoScreen() {

    document.getElementById("Div_Streaming").style.marginLeft = "132px";
    document.getElementById("Div_CtrlHome").style.marginLeft = "132px";
    document.getElementById("Div_CtrlSetting").style.marginLeft = "132px";

    document.getElementById("Div_Streaming").style.display = "block";
    if (cameraSettings.ViewerMode == 0 || cameraSettings.ViewerMode == 1) {
        document.getElementById("Div_CtrlHome").style.display = "block";
    }
    document.getElementById("Div_StreamingFull").style.display = "none";
}

function setVideoScreenFull() {

    document.getElementById("Div_StreamingFull").style.display = "block";
    document.getElementById("Div_Streaming").style.display = "none";
    document.getElementById("Div_CtrlHome").style.display = "none";
    document.getElementById("Div_CtrlSetting").style.display = "none";
}

const autoManual2BoolMap = new Map([
    ["auto", true],
    ["manual", false]
]);

var lastZoomSliderValue = -1;
var zoomDirectTimer;
var zoomDirectRunning = 0;

function sendAbsoluteZoomCmd() {
    var zoomDirectPos;
    if (lastZoomSliderValue == $("#zoomBarRangeInput").val()) {
        return;
    }
    lastZoomSliderValue = $("#zoomBarRangeInput").val();
    if (cameraSettings.ModelName == "CV420e") {
        if (document.getElementById("digitalZoomChkbox").checked == false) {
            zoomDirectPos = parseInt((lastZoomSliderValue * (0x6000 - 0x4000) / 300) + 0x4000).toString(16);
        } else {
            zoomDirectPos = parseInt((lastZoomSliderValue * (0x7AC0 - 0x4000) / 300) + 0x4000).toString(16);
        }
    } else {
        if (cameraSettings.DZoomLimit == "x1") {
            zoomDirectPos = parseInt(lastZoomSliderValue * 0x4000 / 300).toString(16);
        } else {
            zoomDirectPos = parseInt(lastZoomSliderValue * 0x7AC0 / 300).toString(16);
        }
    }
    $.ajax({
        url: "/command/ptzf.cgi" + "?" + "AbsoluteZoom=" + zoomDirectPos + "&_=" + (new Date).getTime(),
        type: "POST",
        error: function (xhr) {
            ;
        },
        success: function (reponse) {
            if (lastZoomSliderValue == $("#zoomBarRangeInput").val()) {
                zoomDirectRunning = 0;
                clearInterval(zoomDirectTimer);
            }
        }
    });
}

function zoomDirectTrigger() {
    if (zoomDirectRunning == 0) {
        zoomDirectRunning = 1;
        zoomDirectTimer = setInterval(sendAbsoluteZoomCmd, 300);
    }
}

function sendZoomStopCmd() {
    $.ajax({
        url: "/command/ptzf.cgi" + "?" + "Move=stop" + "%2Czoom" + "&_=" + (new Date).getTime(),
        type: "POST",
        error: function (xhr) {
            setTimeout("sendZoomStopCmd()", 20);
        },
        success: function (reponse) {
            updateZoomPos();
        }
    });
}

function sendManualFocusCmd(cmd) {
    $.ajax({
        url: "/command/ptzf.cgi" + "?" + "Move=" + cmd + "&_=" + (new Date).getTime(),
        type: "POST",
        error: function (xhr) {
            ;
        },
        success: function (reponse) {
            ;
        }
    });
}

function sendZoomStartCmd(telewide) {
    var speed = 7;
    if (telewide.indexOf('tele') >= 0)
        telewide = 'tele';
    else
        telewide = 'wide';
    if (cameraSettings.ModelName == "CV420e") {
        speed = 0;
    }
    $.ajax({
        url: "/command/ptzf.cgi" + "?" + "Move=" + telewide.toString() + "%2C" + speed + "&_=" + (new Date).getTime(),
        type: "POST",
        error: function (xhr) {
            console.log("Zoom Start :%s fail", telewide.toString());
        },
        success: function (reponse) {
            console.log("Zoom Start tele/wide pass");
        }
    });
}

function updateZoomPos() {

    $.ajax({
        url: "/command/inquiry.cgi?inqjs=ptzf",
        type: "GET",
        error: function (xhr) {
            console.log("Get ptzf info fail");
        },
        success: function (response) {
            var pcDateNow = {};
            const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
            var result = [];
            while (result = regEx.exec(response)) {
                cameraSettings[result[1]] = result[2];
            }

            var zoomPos = parseInt(cameraSettings.AbsolutePTZF.split(',')[2], 16);
            if (cameraSettings.ModelName == "CV420e") {
                if (document.getElementById("digitalZoomChkbox").checked == false) {
                    $("#zoomBarRangeInput").val(parseInt((zoomPos - 0x4000) * 300 / (0x6000 - 0x4000)));
                } else {
                    $("#zoomBarRangeInput").val(parseInt((zoomPos - 0x4000) * 300 / (0x7AC0 - 0x4000)));
                }
            } else {
                if (cameraSettings.DZoomLimit == "x1") {
                    $("#zoomBarRangeInput").val(parseInt(zoomPos * 300 / 0x4000));
                } else {
                    $("#zoomBarRangeInput").val(parseInt(zoomPos * 300 / 0x7AC0));
                }
            }
        }
    })
}

function sendZoomMode() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/camera.cgi?";

    if (document.getElementById("digitalZoomChkbox").checked == false) {
        AddParameter("ZoomMode", "pixel");
    } else {
        AddParameter("ZoomMode", "full");
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send ZoomMode Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            UnblockUIforPage();
            setTimeout(updateZoomPos, 200);
            lastZoomSliderValue = -1;
        }
    });
}
var timer;
var zoom_hold = 0; //absolute zoom process will inhibit zoom start cmd
var zoomstepidx = 0;
var wideRunning = 0;
var teleRunning = 0;
var zoom_mode = "absolute";
var mousedownTimestamp;
var mouseDown = 0;
var zommdelay = 100;
var farRunning = 0;
var nearRunning = 0;

function ActivateManualFocusControl() {
    $('#focusNearButton').on('mousedown', function () {
        nearRunning = 1;
        sendManualFocusCmd('near%2C0');
    }).on('mouseup', function (e) {
        e.stopPropagation();
        nearRunning = 0;
        sendManualFocusCmd('stop%2Cfocus');
    });

    $('#focusFarButton').on('mousedown', function () {
        farRunning = 1;
        sendManualFocusCmd('far%2C0');
    }).on('mouseup', function (e) {
        e.stopPropagation();
        farRunning = 0;
        sendManualFocusCmd('stop%2Cfocus');
    });
}

function ActivateZoomBtnElements() {
    if (cameraSettings.ModelName == "CV420e") {
        zommdelay = 400;
    }
    $(document).on('mouseup', function () {
        if (wideRunning) {
            wideRunning = 0;
            clearTimeout($(this).data('timer'));
            var zoomstop = 0;
            if (mouseDown) {
                if (zoom_hold == 1)
                    return
                event.preventDefault();
                clearInterval(timer);
                zoom_mode = "normal_wide";
                sendZoomStartCmd(zoom_mode);
                updateZoomPos();
            }
            if (!zoomstop) {
                setTimeout(function () {
                    clearInterval(timer);
                    sendZoomStopCmd()
                }, 100);
            }
            mouseDown = 0;
        } else if (teleRunning) {
            teleRunning = 0;
            clearTimeout($(this).data('timer'));
            var zoomstop = 0;
            if (mouseDown) {
                if (zoom_hold == 1)
                    return
                event.preventDefault();
                clearInterval(timer);
                zoom_mode = "normal_tele";
                sendZoomStartCmd(zoom_mode);
                updateZoomPos();
            }
            if (!zoomstop) {
                setTimeout(function () {
                    clearInterval(timer);
                    sendZoomStopCmd()
                }, 100);
            }
            mouseDown = 0;
        }
    });
    $("#zoomWideButton").on({
        mousedown: function (e) {
            wideRunning = 1;
            mouseDown = 1;
            $(this).data('timer', setTimeout(function () {
                mouseDown = 0;
                zoom_mode = "star_wide";
                sendZoomStartCmd(zoom_mode);
                clearInterval(timer);
                timer = setInterval(updateZoomPos, 200);
            }, 1000));
        },
        mouseup: function (e) {
            //zoom step event
            e.stopPropagation();
            wideRunning = 0;
            clearTimeout($(this).data('timer'));
            var zoomstop = 0;
            if (mouseDown) {
                if (zoom_hold == 1)
                    return
                event.preventDefault();
                clearInterval(timer);
                zoom_mode = "normal_wide";
                sendZoomStartCmd(zoom_mode);
                updateZoomPos();
            }
            if (!zoomstop) {
                setTimeout(function () {
                    clearInterval(timer);
                    sendZoomStopCmd()
                }, zommdelay);
            }
            mouseDown = 0;
        }
    });

    $("#zoomTeleButton").on({
        mousedown: function (e) {
            teleRunning = 1;
            mouseDown = 1;
            $(this).data('timer', setTimeout(function () {
                mouseDown = 0;
                zoom_mode = "star_tele";
                sendZoomStartCmd(zoom_mode);
                clearInterval(timer);
                timer = setInterval(updateZoomPos, 200);
            }, 1000));
        },
        mouseup: function (e) {
            //zoom step event
            e.stopPropagation();
            teleRunning = 0;
            clearTimeout($(this).data('timer'));
            var zoomstop = 0;
            if (mouseDown) {
                if (zoom_hold == 1)
                    return
                event.preventDefault();
                clearInterval(timer);
                zoom_mode = "normal_tele";
                sendZoomStartCmd(zoom_mode);
                updateZoomPos();
            }
            if (!zoomstop) {
                setTimeout(function () {
                    clearInterval(timer);
                    sendZoomStopCmd()
                }, zommdelay);
            }
            mouseDown = 0;
        }
    });
}

function sendPanTilttCmd(dir) {
    if (dir == 'stop') {
        var urltoSend = "/command/ptzf.cgi" + "?" + "Move=" + dir.toString() + '%2Cmotor&_=' + (new Date).getTime();
    } else {
        var urltoSend = "/command/ptzf.cgi" + "?" + "Move=" + dir.toString() + '%2C18&_=' + (new Date).getTime();
    }
    $.ajax({
        url: urltoSend,
        type: "POST",
        error: function (xhr) {
            console.log("PanTilt :%s fail", dir.toString());
            if (dir == 'stop')
                setTimeout("sendPanTilttCmd('stop')", 20);
        },
        success: function (reponse) {
            console.log("PanTilt pass");
        }
    });

}

var ptCmdRun = false;

function stopPTMoving() {
    if (ptCmdRun == false)
        return;
    ptCmdRun = false;
    clearTimeout($(this).data('timer'));
    dir = 'stop';
    setTimeout(function () {
        sendPanTilttCmd(dir);
    }, 500);
}

function ActivatePanTiltElement() {
    var dir;
    $('#ptDownLeftButton').on({
        mousedown: function (e) {
            dir = 'down-left';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptDownButton').on({
        mousedown: function (e) {
            dir = 'down';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptDownRightButton').on({
        mousedown: function (e) {
            dir = 'down-right';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptLeftButton').on({
        mousedown: function (e) {
            dir = 'left';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#HomeButton').on({
        mousedown: function (e) {
            sendSingleCGICmd("presetposition", "HomePos", "recall");
        }
    });

    $('#ptRightButton').on({
        mousedown: function (e) {
            dir = 'right';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptUpLeftButton').on({
        mousedown: function (e) {
            dir = 'up-left';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptUpButton').on({
        mousedown: function (e) {
            dir = 'up';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
    $('#ptUpRightButton').on({
        mousedown: function (e) {
            dir = 'up-right';
            ptCmdRun = true;
            setTimeout(function () {
                sendPanTilttCmd(dir);
            }, 100);
        },
        mouseup: function () {
            stopPTMoving();
        },
        mouseleave: function () {
            stopPTMoving();
        }
    });
}

// Gain
var gainParamArr = ["0 dB", "3 dB", "6 dB", "9 dB", "12 dB", "15 dB", "18 dB", "21 dB", "24 dB", "27 dB", "30 dB", "33 dB", "36 dB", "39 dB", "42 dB", "45 dB"];
var gainParamVal = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"];
var curGainIndex = 0;

// Iris
var irisParamArr = ["Close", "F18", "F16", "F13", "F11", "F9", "F7.8", "F6.3", "F5.4", "F4.5", "F3.8", "F3.2", "F2.7", "F2.2", "F2", "F1.6"];
var irisParamVal = ["15", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"];
var curIrisIndex = 0;

// Shutter Speed
var shutterSpeedParamArr = ["1/10000", "1/5000", "1/3000", "1/2500", "1/2000", "1/1500", "1/1000", "1/725", "1/500", "1/350", "1/250", "1/180", "1/120", "1/100", "1/90", "1/60", "1/30", "1/15", "1/8", "1/4", "1/2", "1/1"];
var shutterSpeedParamArr50 = ["1/10000", "1/5000", "1/3000", "1/2500", "1/1750", "1/1250", "1/1000", "1/600", "1/425", "1/300", "1/215", "1/150", "1/120", "1/100", "1/75", "1/50", "1/25", "1/12", "1/6", "1/3", "1/2", "1/1"];
var shutterSpeedParamVal = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"];
var curShutterSpeedIndex = 0;

const expCompMap = new Map([
["textId", "exposureCompLevelTextInput"],
["minusBtn", "#exposureCompLevelMinusButtonInput"],
["plusBtn", "#exposureCompLevelPlusButtonInput"]
])

const gainLevelMap = new Map([
["textId", "gainLevelTextInput"],
["minusBtn", "#gainLevelMinusButtonInput"],
["plusBtn", "#gainLevelPlusButtonInput"]
])

const irisMap = new Map([
["textId", "irisTextInput"],
["minusBtn", "#irisMinusButtonInput"],
["plusBtn", "#irisPlusButtonInput"]
])

const shutterMap = new Map([
["textId", "shutterTextInput"],
["minusBtn", "#shutterMinusButtonInput"],
["plusBtn", "#shutterPlusButtonInput"]
])

const manualRedMap = new Map([
["textId", "manualRedTextInput"],
["minusBtn", "#manualRedMinusButtonInput"],
["plusBtn", "#manualRedPlusButtonInput"]
]);

const manualBlueMap = new Map([
["textId", "manualBlueTextInput"],
["minusBtn", "#manualBlueMinusButtonInput"],
["plusBtn", "#manualBluePlusButtonInput"]
]);

const panRightLimitMap = new Map([
["textId", "panRightLimitTextInput"],
["minusBtn", "#panRightLimitMinusButtonInput"],
["plusBtn", "#panRightLimitPlusButtonInput"]
]);

const panLeftLimitMap = new Map([
["textId", "panLeftLimitTextInput"],
["minusBtn", "#panLeftLimitMinusButtonInput"],
["plusBtn", "#panLeftLimitPlusButtonInput"]
]);

const tiltUpLimitMap = new Map([
["textId", "tiltUpLimitTextInput"],
["minusBtn", "#tiltUpLimitMinusButtonInput"],
["plusBtn", "#tiltUpLimitPlusButtonInput"]
]);

const tiltDownLimitMap = new Map([
["textId", "tiltDownLimitTextInput"],
["minusBtn", "#tiltDownLimitMinusButtonInput"],
["plusBtn", "#tiltDownLimitPlusButtonInput"]
]);

const hueMap = new Map([
["textId", "hueTextInput"],
["minusBtn", "#hueMinusButtonInput"],
["plusBtn", "#huePlusButtonInput"]
]);

const gammaMap = new Map([
["textId", "gammaTextInput"],
["minusBtn", "#gammaMinusButtonInput"],
["plusBtn", "#gammaPlusButtonInput"]
]);

const brightnessMap = new Map([
["textId", "brightnessTextInput"],
["minusBtn", "#brightnessMinusButtonInput"],
["plusBtn", "#brightnessPlusButtonInput"]
]);

const saturationMap = new Map([
["textId", "saturationTextInput"],
["minusBtn", "#saturationMinusButtonInput"],
["plusBtn", "#saturationPlusButtonInput"]
]);

const sharpnessMap = new Map([
["textId", "sharpnessTextInput"],
["minusBtn", "#sharpnessMinusButtonInput"],
["plusBtn", "#sharpnessPlusButtonInput"]
]);

function updateDisableMinusPlusUI(id, disable) {
    var setMap;
    if (id == "EXP_COMP") {
        setMap = expCompMap;
    } else if (id == "GAIN_LEVEL") {
        setMap = gainLevelMap;
    } else if (id == "IRIS") {
        setMap = irisMap;
    } else if (id == "SHUTTER") {
        setMap = shutterMap;
    } else if (id == "MANUAL_RED") {
        setMap = manualRedMap;
    } else if (id == "MANUAL_BLUE") {
        setMap = manualBlueMap;
    } else if (id == "PAN_RIGHT_LIMIT") {
        setMap = panRightLimitMap;
    } else if (id == "PAN_LEFT_LIMIT") {
        setMap = panLeftLimitMap;
    } else if (id == "TILT_UP_LIMIT") {
        setMap = tiltUpLimitMap;
    } else if (id == "TILT_DOWN_LIMIT") {
        setMap = tiltDownLimitMap;
    } else if (id == "HUE") {
        setMap = hueMap;
    } else if (id == "GAMMA") {
        setMap = gammaMap;
    } else if (id == "BRIGHTNESS") {
        setMap = brightnessMap;
    } else if (id == "SATURATION") {
        setMap = saturationMap;
    } else if (id == "SHARPNESS") {
        setMap = sharpnessMap;
    }
    if (disable == true) {
        document.getElementById(setMap.get("textId")).disabled = true;
        $(setMap.get("minusBtn")).addClass("disabled").prop("disabled", true);
        $(setMap.get("plusBtn")).addClass("disabled").prop("disabled", true);
    } else if (disable == false) {
        document.getElementById(setMap.get("textId")).disabled = false;
        $(setMap.get("minusBtn")).removeClass("disabled").prop("disabled", false);
        $(setMap.get("plusBtn")).removeClass("disabled").prop("disabled", false);
    }
}

function setCmdAction(textId, para, newVal, refreshHndlr) {
    function sendCGICmdAndUpdateWeb(name, cmd, value, textId, id) {
        updateDisableMinusPlusUI(id, true);
        $.ajax({
            url: "/command/" + name + ".cgi?" + cmd + "=" + value + "&_=" + (new Date).getTime(),
            type: "POST",
            error: function (xhr) {
                ;
            },
            success: function (reponse) {
                if (para == "ExposureCompensation") {
                    $(textId).val(value - 5);
                } else {
                    $(textId).val(value);
                }
            }
        });
        updateDisableMinusPlusUI(id, false);
    }
    var sendVal;
    if (para == "ExposureCompensation") {
        cameraSettings[para] = newVal + 5;
        sendVal = newVal + 5;
    } else {
        cameraSettings[para] = newVal;
        sendVal = newVal;
    }
    if (para == "ExposureCompensation") {
        sendCGICmdAndUpdateWeb("imaging", "ExposureCompensation", sendVal, "#exposureCompLevelTextInput", "EXP_COMP");
    } else if (para == "WhiteBalanceCrGain") {
        sendCGICmdAndUpdateWeb("imaging", "WhiteBalanceCrGain", sendVal, "#manualRedTextInput", "MANUAL_RED");
    } else if (para == "WhiteBalanceCbGain") {
        sendCGICmdAndUpdateWeb("imaging", "WhiteBalanceCbGain", sendVal, "#manualBlueTextInput", "MANUAL_BLUE");
    } else if (para == "PanRightLimit") {
        sendCGICmdAndUpdateWeb("camera", "PanRightLimit", sendVal, "#panRightLimitTextInput", "PAN_RIGHT_LIMIT");
    } else if (para == "PanLeftLimit") {
        sendCGICmdAndUpdateWeb("camera", "PanLeftLimit", sendVal, "#panLeftLimitTextInput", "PAN_LEFT_LIMIT");
    } else if (para == "TiltUpLimit") {
        sendCGICmdAndUpdateWeb("camera", "TiltUpLimit", sendVal, "#tiltUpLimitTextInput", "TILT_UP_LIMIT");
    } else if (para == "TiltDownLimit") {
        sendCGICmdAndUpdateWeb("camera", "TiltDownLimit", sendVal, "#tiltDownLimitTextInput", "TILT_DOWN_LIMIT");
    } else if (para == "ColorHue") {
        sendCGICmdAndUpdateWeb("imaging", "ColorHue", sendVal, "#hueTextInput", "HUE");
    } else if (para == "GammaLevel") {
        sendCGICmdAndUpdateWeb("imaging", "GammaLevel", sendVal, "#gammaTextInput", "GAMMA");
    } else if (para == "DigitalBrightLevel") {
        sendCGICmdAndUpdateWeb("imaging", "DigitalBrightLevel", sendVal, "#brightnessTextInput", "BRIGHTNESS");
    } else if (para == "ColorSaturation") {
        sendCGICmdAndUpdateWeb("imaging", "ColorSaturation", sendVal, "#saturationTextInput", "SATURATION");
    } else if (para == "DetailLevel") {
        sendCGICmdAndUpdateWeb("imaging", "DetailLevel", sendVal, "#sharpnessTextInput", "SHARPNESS");
    }
}

/* copy from polish.js */
// Parse decimal integers
function parseDecimal(x) {
    return parseInt(x, 10);
}

function liesBetween(low, value, high) {
    return (low <= value) && (value <= high);
}
var ASCII = {
    BACKSPACE: 8,
    TAB: 9,
    CR: 13,
    SPACE: 32,
    LEFT: 37,
    UP: 38,
    RIGHT: 39,
    DOWN: 40,
    COMMA: 44,
    HYPHEN: 45,
    PERIOD: 46,
    SLASH: 47,
    ZERO: 48,
    NINE: 57,
    COLON: 58,
    SEMICOLON: 59,
    AT: 64,
    A: 65,
    Z: 90,
    UNDERSCORE: 95,
    a: 97,
    z: 122
};

function isASCIINegKey(keycode) {
    return (keycode === ASCII.HYPHEN);
}

function isASCIIControlKey(keycode) {
    return (keycode === ASCII.BACKSPACE) || (keycode === ASCII.CR) || (keycode === ASCII.TAB);
}

function isASCIINumKey(keycode) {
    return liesBetween(ASCII.ZERO, keycode, ASCII.NINE);
}

function exists(a, verifier) {
    var valid = false;
    $.each(a, function (i, e) {
        if (verifier(i, e)) {
            valid = true;
        }
    });
    return valid;
}

// Checks whether the keyevent matches any of the predicate functions
function keyEventCheck(keyEvent, predicates) {
    var keycode = (keyEvent.which) ? keyEvent.which : keyEvent.keycode;
    var keyOk;
    console.log("keyCode is..." + keycode);
    if (typeof (keycode) === "undefined") { //This is because arrow keys and #, $, % and ( are overlapping in FF.
        keyOk = true;
    } else {
        keyOk = exists(predicates, function (i, predicate) {
            return predicate(keycode);
        });
    }
    if (!keyOk) {
        console.log("Rejecting key" + keycode);
    }
    return keyOk;
}

function filterNegNumKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, isASCIINegKey]);
}

function filterNumKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey]);
}

function registerChangeHandlers(jqObj, handler) {
    // The input propertychange idea comes from: http://stackoverflow.com/a/8558045
    return jqObj.change(handler).keyup(handler).click(handler).bind("input propertyChange", handler);
}

function presetTextAction(strSet) {
    var strVal = $("#presetInput").val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            if (strVal == "0") {
                strVal = strSet;
            } else {
                strVal = strVal.concat(strSet);
            }
            break;
        case 2:
            if (strSet < "6") {
                if (strVal <= "25") {
                    strVal = strVal.concat(strSet);
                }
                //else do nothing
            } else {
                if (strVal <= "24") {
                    strVal = strVal.concat(strSet);
                }
            }
            break;
        case 3:
            //do nothing
            break;
        case 4:
            strVal = "";
            break;
    }
    $("#presetInput").val(strVal);
}

function updateExposurePageSelect() {
    $("#exposureModeSelect").append($("<option></option>").val("auto").text("Full Auto"));
    $("#exposureModeSelect").append($("<option></option>").val("shutter").text("Shutter Pri"));
    if (cameraSettings.ModelName != "CV420e") {
        $("#exposureModeSelect").append($("<option></option>").val("iris").text("Iris Pri"));
    }
    $("#exposureModeSelect").append($("<option></option>").val("manual").text("Manual"));
    $("#wdrSelect").append($("<option></option>").val("0").text("Off"));
    $("#wdrSelect").append($("<option></option>").val("1").text("1"));
    $("#wdrSelect").append($("<option></option>").val("2").text("2"));
    $("#wdrSelect").append($("<option></option>").val("3").text("3"));
}

function updateExposurePageValue() {
    $("#exposureModeSelect").val(cameraSettings.ExposureMode);
    $("#exposureCompLevelTextInput").val(cameraSettings.ExposureCompensation - 5);
    $("#wdrSelect").val(cameraSettings.VisibilityEnhancerLevel);
    curGainIndex = gainParamVal.indexOf(cameraSettings.ExposureGain);
    $("#gainLevelTextInput").val(gainParamArr[curGainIndex]);

    if (cameraSettings.ExposureMode == "iris") {
        curIrisIndex = irisParamVal.indexOf(cameraSettings.ExposureIrisPri);
    } else {
        curIrisIndex = irisParamVal.indexOf(cameraSettings.ExposureIris);
    }
    $("#irisTextInput").val(irisParamArr[curIrisIndex]);

    if (cameraSettings.ExposureMode == "shutter") {
        curShutterSpeedIndex = shutterSpeedParamVal.indexOf(cameraSettings.ExposureExposureTimePri);
    } else {
        curShutterSpeedIndex = shutterSpeedParamVal.indexOf(cameraSettings.ExposureExposureTime);
    }
    if (cameraSettings.Resolution.indexOf("50") >= 0 || cameraSettings.Resolution.indexOf("25") >= 0) {
        $("#shutterTextInput").val(shutterSpeedParamArr50[curShutterSpeedIndex]);
    } else {
        $("#shutterTextInput").val(shutterSpeedParamArr[curShutterSpeedIndex]);
    }
}

function updateExposureMode() {
    var mode = $("#exposureModeSelect").val();
    if (mode == "auto") {
        updateDisableMinusPlusUI("EXP_COMP", false);
        updateDisableMinusPlusUI("GAIN_LEVEL", true);
        updateDisableMinusPlusUI("IRIS", true);
        updateDisableMinusPlusUI("SHUTTER", true);
    } else if (mode == "shutter") {
        updateDisableMinusPlusUI("EXP_COMP", false);
        updateDisableMinusPlusUI("GAIN_LEVEL", true);
        updateDisableMinusPlusUI("IRIS", true);
        updateDisableMinusPlusUI("SHUTTER", false);
    } else if (mode == "iris") {
        updateDisableMinusPlusUI("EXP_COMP", false);
        updateDisableMinusPlusUI("GAIN_LEVEL", true);
        updateDisableMinusPlusUI("IRIS", false);
        updateDisableMinusPlusUI("SHUTTER", true);
    } else if (mode == "manual") {
        updateDisableMinusPlusUI("EXP_COMP", true);
        updateDisableMinusPlusUI("GAIN_LEVEL", false);
        updateDisableMinusPlusUI("IRIS", false);
        updateDisableMinusPlusUI("SHUTTER", false);
    }
    if (mode == "iris") {
        curIrisIndex = irisParamVal.indexOf(cameraSettings.ExposureIrisPri);
    } else {
        curIrisIndex = irisParamVal.indexOf(cameraSettings.ExposureIris);
    }
    $("#irisTextInput").val(irisParamArr[curIrisIndex]);

    if (mode == "shutter") {
        curShutterSpeedIndex = shutterSpeedParamVal.indexOf(cameraSettings.ExposureExposureTimePri);
    } else {
        curShutterSpeedIndex = shutterSpeedParamVal.indexOf(cameraSettings.ExposureExposureTime);
    }
    if (cameraSettings.Resolution.indexOf("50") >= 0 || cameraSettings.Resolution.indexOf("25") >= 0) {
        $("#shutterTextInput").val(shutterSpeedParamArr50[curShutterSpeedIndex]);
    } else {
        $("#shutterTextInput").val(shutterSpeedParamArr[curShutterSpeedIndex]);
    }
}

function updateWhiteBalancePageSelect() {
    $("#wbModeSelect").append($("<option></option>").val("auto").text("Auto"));
    $("#wbModeSelect").append($("<option></option>").val("indoor").text("Indoor"));
    $("#wbModeSelect").append($("<option></option>").val("outdoor").text("Outdoor"));
    $("#wbModeSelect").append($("<option></option>").val("onepushwb").text("One Push WB"));
    $("#wbModeSelect").append($("<option></option>").val("atw").text("ATW"));
    $("#wbModeSelect").append($("<option></option>").val("manual").text("Manual"));
    $("#wbModeSelect").append($("<option></option>").val("sodiumlamp").text("Sodium Lamp"));
}

function updateWhiteBalancePageValue() {
    $("#wbModeSelect").val(cameraSettings.WhiteBalanceMode);
    $("#manualRedTextInput").val(cameraSettings.WhiteBalanceCrGain);
    $("#manualBlueTextInput").val(cameraSettings.WhiteBalanceCbGain);
}

function updateWhiteBalanceMode() {
    var mode = $("#wbModeSelect").val();
    if (mode == "onepushwb") {
        document.getElementById("onePushAwbButton").disabled = false;
        updateDisableMinusPlusUI("MANUAL_RED", true);
        updateDisableMinusPlusUI("MANUAL_BLUE", true);
    } else if (mode == "manual") {
        document.getElementById("onePushAwbButton").disabled = true;
        updateDisableMinusPlusUI("MANUAL_RED", false);
        updateDisableMinusPlusUI("MANUAL_BLUE", false);
    } else {
        document.getElementById("onePushAwbButton").disabled = true;
        updateDisableMinusPlusUI("MANUAL_RED", true);
        updateDisableMinusPlusUI("MANUAL_BLUE", true);
    }
}

function updateFocusPageSelect() {
    $("#afSensitivitySelect").append($("<option></option>").val("low").text("Low"));
    $("#afSensitivitySelect").append($("<option></option>").val("middle").text("Middle"));
    $("#afSensitivitySelect").append($("<option></option>").val("high").text("High"));
    $("#afFrameSelect").append($("<option></option>").val("center").text("Center"));
    $("#afFrameSelect").append($("<option></option>").val("full").text("Full Frame"));
    $("#afFrameSelect").append($("<option></option>").val("auto").text("Auto"));
}

function updateFocusPageValue() {
    $("#afSensitivitySelect").val(cameraSettings.AFSensitivity);
    $("#afFrameSelect").val(cameraSettings.AFFrame);
    $("#zoomTrackingCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.ZoomTracking));
    $("#ptzAssistCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.PTZAssist));
    $("#smartAfCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.SmartAF));
}

function updateFocusMode() {
    if (document.getElementById("focusModeCheckboxInput").checked == true) {
        // Auto Focus
        document.getElementById("afSensitivitySelect").disabled = false;
        document.getElementById("afFrameSelect").disabled = false;
        $("#focusNearButton").addClass("disabled").prop("disabled", true);
        $("#focusFarButton").addClass("disabled").prop("disabled", true);
        $("#zoomTrackingCheckboxInput").addClass("disabled").prop("disabled", true);
        $("#ptzAssistCheckboxInput").addClass("disabled").prop("disabled", true);
        $("#onePushAfButton").addClass("disabled").prop("disabled", true);

        $("#smartAfCheckboxInput").removeClass("disabled").prop("disabled", false);
    } else {
        // Manual Focus
        document.getElementById("afSensitivitySelect").disabled = true;
        $("#focusNearButton").removeClass("disabled").prop("disabled", false);
        $("#focusFarButton").removeClass("disabled").prop("disabled", false);
        $("#zoomTrackingCheckboxInput").removeClass("disabled").prop("disabled", false);
        $("#ptzAssistCheckboxInput").removeClass("disabled").prop("disabled", false);
        $("#onePushAfButton").removeClass("disabled").prop("disabled", false);

        $("#smartAfCheckboxInput").addClass("disabled").prop("disabled", true);
        updatePtzAssist();
    }
}

function updatePtzAssist() {
    if (document.getElementById("ptzAssistCheckboxInput").checked == true) {
        document.getElementById("afFrameSelect").disabled = false;
    } else {
        document.getElementById("afFrameSelect").disabled = true;
    }
}

function updateMirrorPageValue() {
    if (cameraSettings.Mirror == "off") {
        $("#mirrorCheckboxInput").prop("checked", false);
        $("#flipCheckboxInput").prop("checked", false);
    } else if (cameraSettings.Mirror == "mirror") {
        $("#mirrorCheckboxInput").prop("checked", true);
        $("#flipCheckboxInput").prop("checked", false);
    } else if (cameraSettings.Mirror == "flip") {
        $("#mirrorCheckboxInput").prop("checked", false);
        $("#flipCheckboxInput").prop("checked", true);
    } else if (cameraSettings.Mirror == "mirror+flip") {
        $("#mirrorCheckboxInput").prop("checked", true);
        $("#flipCheckboxInput").prop("checked", true);
    }
}

function updatePtzPageSelect() {
    $("#panFlipSelect").append($("<option></option>").val("on").text("On"));
    $("#panFlipSelect").append($("<option></option>").val("off").text("Off"));
    $("#tiltFlipSelect").append($("<option></option>").val("on").text("On"));
    $("#tiltFlipSelect").append($("<option></option>").val("off").text("Off"));
    $("#presetSpeedSelect").append($("<option></option>").val("0").text("5 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("1").text("25 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("2").text("50 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("3").text("80 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("4").text("120 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("5").text("160 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("6").text("200 deg/sec"));
    $("#presetSpeedSelect").append($("<option></option>").val("7").text("300 deg/sec"));
    $("#ptzSpeedCompSelect").append($("<option></option>").val("on").text("On"));
    $("#ptzSpeedCompSelect").append($("<option></option>").val("off").text("Off"));
    $("#initialPositionSelect").append($("<option></option>").val("lastmem").text("Last MEM"));
    $("#initialPositionSelect").append($("<option></option>").val("1stpreset").text("1st Preset"));
    $("#motionlessPresetSelect").append($("<option></option>").val("freeze").text("On"));
    $("#motionlessPresetSelect").append($("<option></option>").val("normal").text("Off"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x1").text("x1"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x2").text("x2"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x3").text("x3"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x4").text("x4"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x5").text("x5"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x6").text("x6"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x7").text("x7"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x8").text("x8"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x9").text("x9"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x10").text("x10"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x11").text("x11"));
    $("#dzoomLimitSelect").append($("<option></option>").val("x12").text("x12"));
    $("#ptzMotionSyncSelect").append($("<option></option>").val("on").text("On"));
    $("#ptzMotionSyncSelect").append($("<option></option>").val("off").text("Off"));
}

function updatePtzPageValue() {
    $("#panTiltLimitCheckboxInput").prop("checked", OnOff2BoolMap.get(cameraSettings.PanTiltLimit));
    $("#panRightLimitTextInput").val(cameraSettings.PanRightLimit);
    $("#panLeftLimitTextInput").val(cameraSettings.PanLeftLimit);
    $("#tiltUpLimitTextInput").val(cameraSettings.TiltUpLimit);
    $("#tiltDownLimitTextInput").val(cameraSettings.TiltDownLimit);
    $("#panFlipSelect").val(cameraSettings.PanFlip);
    $("#tiltFlipSelect").val(cameraSettings.TiltFlip);
    $("#presetSpeedSelect").val(cameraSettings.PresetSpeed);
    $("#ptzSpeedCompSelect").val(cameraSettings.PTZSpeedComp);
    $("#initialPositionSelect").val(cameraSettings.InitPosition);
    $("#motionlessPresetSelect").val(cameraSettings.CallMode);
    $("#ptzMotionSyncSelect").val(cameraSettings.PTZMotionSync);
    if ((cameraSettings.Resolution == "2160p_5994" || cameraSettings.Resolution == "2160p_50") && (cameraSettings.OutputSource == "hdmi+ndi" || cameraSettings.OutputSource == "hdmi+stream")) {
        $("#dzoomLimitSelect").val("x1").addClass("disabled").prop("disabled", true);
    } else {
        $("#dzoomLimitSelect").val(cameraSettings.DZoomLimit);
    }
}

function updatePanTiltLimit() {
    if (document.getElementById("panTiltLimitCheckboxInput").checked == true) {
        updateDisableMinusPlusUI("PAN_RIGHT_LIMIT", false);
        updateDisableMinusPlusUI("PAN_LEFT_LIMIT", false);
        updateDisableMinusPlusUI("TILT_UP_LIMIT", false);
        updateDisableMinusPlusUI("TILT_DOWN_LIMIT", false);
    } else {
        updateDisableMinusPlusUI("PAN_RIGHT_LIMIT", true);
        updateDisableMinusPlusUI("PAN_LEFT_LIMIT", true);
        updateDisableMinusPlusUI("TILT_UP_LIMIT", true);
        updateDisableMinusPlusUI("TILT_DOWN_LIMIT", true);
    }
}

function updatePicturePageSelect() {
    $("#pictureEffectSelect").append($("<option></option>").val("off").text("Off"));
    $("#pictureEffectSelect").append($("<option></option>").val("neg").text("Neg"));
    $("#pictureEffectSelect").append($("<option></option>").val("bw").text("B&W"));

    $("#_2dnrSelect").append($("<option></option>").val("0").text("Off"));
    $("#_2dnrSelect").append($("<option></option>").val("1").text("1"));
    $("#_2dnrSelect").append($("<option></option>").val("2").text("2"));
    $("#_2dnrSelect").append($("<option></option>").val("3").text("3"));

    $("#_3dnrSelect").append($("<option></option>").val("0").text("Off"));
    $("#_3dnrSelect").append($("<option></option>").val("1").text("Low"));
    $("#_3dnrSelect").append($("<option></option>").val("2").text("Typ"));
    $("#_3dnrSelect").append($("<option></option>").val("3").text("Max"));

    $("#imageModeSelect").append($("<option></option>").val("default").text("Default"));
    $("#imageModeSelect").append($("<option></option>").val("custom").text("Custom"));

    $("#imageModeLoadSelect").append($("<option></option>").val("").text("Default"));
}

function updatePicturePageValue() {
    $("#pictureEffectSelect").val(cameraSettings.PictureEffect);
    $("#_2dnrSelect").val(cameraSettings.NoiseReduction2DLevel);
    $("#_3dnrSelect").val(cameraSettings.NoiseReduction3DLevel);
    $("#imageModeSelect").val(cameraSettings.ImageMode);
    $("#hueTextInput").val(cameraSettings.ColorHue);
    $("#gammaTextInput").val(cameraSettings.GammaLevel);
    $("#brightnessTextInput").val(cameraSettings.DigitalBrightLevel);
    $("#saturationTextInput").val(cameraSettings.ColorSaturation);
    $("#sharpnessTextInput").val(cameraSettings.DetailLevel);
}

function updateImageMode() {
    if ($("#imageModeSelect").val() == "default") {
        document.getElementById("imageModeLoadSelect").disabled = true;
        updateDisableMinusPlusUI("HUE", true);
        updateDisableMinusPlusUI("GAMMA", true);
        updateDisableMinusPlusUI("BRIGHTNESS", true);
        updateDisableMinusPlusUI("SATURATION", true);
        $("#hueTextInput").val("7");
        $("#gammaTextInput").val("3");
        $("#brightnessTextInput").val("7");
        $("#saturationTextInput").val("7");
    } else {
        document.getElementById("imageModeLoadSelect").disabled = false;
        updateDisableMinusPlusUI("HUE", false);
        updateDisableMinusPlusUI("GAMMA", false);
        updateDisableMinusPlusUI("BRIGHTNESS", false);
        updateDisableMinusPlusUI("SATURATION", false);
        $("#hueTextInput").val(cameraSettings.ColorHue);
        $("#gammaTextInput").val(cameraSettings.GammaLevel);
        $("#brightnessTextInput").val(cameraSettings.DigitalBrightLevel);
        $("#saturationTextInput").val(cameraSettings.ColorSaturation);
    }
}

function sendSingleCGICmd(name, cmd, value) {
    if (cmd == "SmartAF") {
        blockUIforPage();
    }
    $.ajax({
        url: "/command/" + name + ".cgi?" + cmd + "=" + value + "&_=" + (new Date).getTime(),
        type: "POST",
        error: function (xhr) {
            if (cmd == "SmartAF") {
                UnblockUIforPage();
            }
        },
        success: function (reponse) {
            if (cmd == "SmartAF") {
                UnblockUIforPage();
            }
            if (cmd == "PresetCall") {
                openLiveview();
            }
        }
    });
}

function reloadImageMode() {

    $.ajax({
        url: "/command/inquiry.cgi?inqjs=imaging",
        type: "GET",
        error: function (xhr) {
            console.log("Reload Imaging fail");
        },
        success: function (response) {
            var pcDateNow = {};
            const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
            var result = [];
            while (result = regEx.exec(response)) {
                cameraSettings[result[1]] = result[2];
            }
            updateImageMode();
        }
    })
}

function activateExposurePageElements() {
    $("#exposureModeSelect").change(function () {
        updateExposureMode();
        sendSingleCGICmd("imaging", "ExposureMode", $("#exposureModeSelect").val());
    });
    connectButtonToInput("#exposureCompLevelMinusButtonInput", "#exposureCompLevelPlusButtonInput", "#exposureCompLevelTextInput",
        cameraSettings, "ExposureCompensation", -5, 5, 1, 1, null);
    $("#gainLevelMinusButtonInput").on('click', function () {
        if (curGainIndex <= 0)
            return;

        curGainIndex -= 1;
        document.getElementById("gainLevelTextInput").value = gainParamArr[curGainIndex];
        sendSingleCGICmd("imaging", "ExposureGain", gainParamVal[curGainIndex]);
    });
    $("#gainLevelPlusButtonInput").on('click', function () {
        if (curGainIndex >= gainParamArr.length - 1)
            return;

        curGainIndex += 1;
        document.getElementById("gainLevelTextInput").value = gainParamArr[curGainIndex];
        sendSingleCGICmd("imaging", "ExposureGain", gainParamVal[curGainIndex]);
    });
    $("#irisMinusButtonInput").on('click', function () {
        if (curIrisIndex <= 0)
            return;

        curIrisIndex -= 1;
        document.getElementById("irisTextInput").value = irisParamArr[curIrisIndex];
        sendSingleCGICmd("imaging", "ExposureIris", irisParamVal[curIrisIndex]);
    });
    $("#irisPlusButtonInput").on('click', function () {
        if (curIrisIndex >= irisParamArr.length - 1)
            return;

        curIrisIndex += 1;
        document.getElementById("irisTextInput").value = irisParamArr[curIrisIndex];
        sendSingleCGICmd("imaging", "ExposureIris", irisParamVal[curIrisIndex]);
    });
    $("#wdrSelect").change(function () {
        sendSingleCGICmd("imaging", "VisibilityEnhancerLevel", $("#wdrSelect").val());
    });
    $("#shutterMinusButtonInput").on('click', function () {
        if (curShutterSpeedIndex <= 0)
            return;

        curShutterSpeedIndex -= 1;
        if (cameraSettings.Resolution.indexOf("50") >= 0 || cameraSettings.Resolution.indexOf("25") >= 0) {
            document.getElementById("shutterTextInput").value = shutterSpeedParamArr50[curShutterSpeedIndex];
        } else {
            document.getElementById("shutterTextInput").value = shutterSpeedParamArr[curShutterSpeedIndex];
        }
        sendSingleCGICmd("imaging", "ExposureExposureTime", shutterSpeedParamVal[curShutterSpeedIndex]);
    });
    $("#shutterPlusButtonInput").on('click', function () {
        if (curShutterSpeedIndex >= shutterSpeedParamVal.length - 1)
            return;

        curShutterSpeedIndex += 1;
        if (cameraSettings.Resolution.indexOf("50") >= 0 || cameraSettings.Resolution.indexOf("25") >= 0) {
            document.getElementById("shutterTextInput").value = shutterSpeedParamArr50[curShutterSpeedIndex];
        } else {
            document.getElementById("shutterTextInput").value = shutterSpeedParamArr[curShutterSpeedIndex];
        }
        sendSingleCGICmd("imaging", "ExposureExposureTime", shutterSpeedParamVal[curShutterSpeedIndex]);
    });
}

function activateWhiteBalancePageElements() {
    $("#wbModeSelect").change(function () {
        updateWhiteBalanceMode();
        sendSingleCGICmd("imaging", "WhiteBalanceMode", $("#wbModeSelect").val());
    });
    $("#onePushAwbButton").on('click', function () {
        sendSingleCGICmd("imaging", "WhiteBalanceOnePushTrg", "on");
    });
    connectButtonToInput("#manualRedMinusButtonInput", "#manualRedPlusButtonInput", "#manualRedTextInput",
        cameraSettings, "WhiteBalanceCrGain", 0, 128, 1, 1, null);
    connectButtonToInput("#manualBlueMinusButtonInput", "#manualBluePlusButtonInput", "#manualBlueTextInput",
        cameraSettings, "WhiteBalanceCbGain", 0, 128, 1, 1, null);
}

function activateFocusPageElements() {
    $("#afSensitivitySelect").change(function () {
        sendSingleCGICmd("camera", "AFSensitivity", $("#afSensitivitySelect").val());
    });
    $("#afFrameSelect").change(function () {
        sendSingleCGICmd("camera", "AFFrame", $("#afFrameSelect").val());
    });
    $("#zoomTrackingCheckboxInput").change(function () {
        var onoff = ($('#zoomTrackingCheckboxInput').is(':checked') == true) ? "on" : "off";
        sendSingleCGICmd("camera", "ZoomTracking", onoff);
    });
    $("#ptzAssistCheckboxInput").change(function () {
        var onoff = ($('#ptzAssistCheckboxInput').is(':checked') == true) ? "on" : "off";
        updatePtzAssist();
        sendSingleCGICmd("camera", "PTZAssist", onoff);
    });
    $("#smartAfCheckboxInput").change(function () {
        var onoff = ($('#smartAfCheckboxInput').is(':checked') == true) ? "on" : "off";
        sendSingleCGICmd("camera", "SmartAF", onoff);
    });
    $("#onePushAfButton").on('click', function () {
        sendSingleCGICmd("ptzf", "Move", "onepushaf,0");
    });
}

function activateMirrorPageElements() {
    function sendMirrorFlipCommand() {
        var mirror = ($('#mirrorCheckboxInput').is(':checked') == true) ? "on" : "off";
        var flip = ($('#flipCheckboxInput').is(':checked') == true) ? "on" : "off";
        var mirrorFlip;
        if (mirror == "off" && flip == "off") {
            mirrorFlip = "off";
        } else if (mirror == "on" && flip == "off") {
            mirrorFlip = "mirror";
        } else if (mirror == "off" && flip == "on") {
            mirrorFlip = "flip";
        } else if (mirror == "on" && flip == "on") {
            mirrorFlip = "mirror+flip";
        }
        sendSingleCGICmd("camera", "Mirror", mirrorFlip);
    }
    $("#mirrorCheckboxInput").change(function () {
        sendMirrorFlipCommand();
    });
    $("#flipCheckboxInput").change(function () {
        sendMirrorFlipCommand();
    });
}

function activatePTZPageElements() {
    $("#panTiltLimitCheckboxInput").change(function () {
        var onoff = ($('#panTiltLimitCheckboxInput').is(':checked') == true) ? "on" : "off";
        updatePanTiltLimit();
        sendSingleCGICmd("camera", "PanTiltLimit", onoff);
    });
    connectButtonToInput("#panRightLimitMinusButtonInput", "#panRightLimitPlusButtonInput", "#panRightLimitTextInput",
        cameraSettings, "PanRightLimit", 0, 170, 1, 1, null);
    connectButtonToInput("#panLeftLimitMinusButtonInput", "#panLeftLimitPlusButtonInput", "#panLeftLimitTextInput",
        cameraSettings, "PanLeftLimit", -170, 0, 1, 1, null);
    connectButtonToInput("#tiltUpLimitMinusButtonInput", "#tiltUpLimitPlusButtonInput", "#tiltUpLimitTextInput",
        cameraSettings, "TiltUpLimit", 0, 90, 1, 1, null);
    connectButtonToInput("#tiltDownLimitMinusButtonInput", "#tiltDownLimitPlusButtonInput", "#tiltDownLimitTextInput",
        cameraSettings, "TiltDownLimit", -30, 0, 1, 1, null);
    $("#panFlipSelect").change(function () {
        sendSingleCGICmd("camera", "PanFlip", $("#panFlipSelect").val());
    });
    $("#tiltFlipSelect").change(function () {
        sendSingleCGICmd("camera", "TiltFlip", $("#tiltFlipSelect").val());
    });
    $("#presetSpeedSelect").change(function () {
        sendSingleCGICmd("camera", "PresetSpeed", $("#presetSpeedSelect").val());
    });
    $("#ptzSpeedCompSelect").change(function () {
        sendSingleCGICmd("camera", "PTZSpeedComp", $("#ptzSpeedCompSelect").val());
    });
    $("#initialPositionSelect").change(function () {
        sendSingleCGICmd("camera", "InitPosition", $("#initialPositionSelect").val());
    });
    $("#motionlessPresetSelect").change(function () {
        sendSingleCGICmd("presetposition", "CallMode", $("#motionlessPresetSelect").val());
    });
    $("#dzoomLimitSelect").change(function () {
        sendSingleCGICmd("camera", "DZoomLimit", $("#dzoomLimitSelect").val());
    });
    $("#ptzMotionSyncSelect").change(function () {
        sendSingleCGICmd("camera", "PTZMotionSync", $("#ptzMotionSyncSelect").val());
    });
}

function activatePicturePageElements() {
    $("#pictureEffectSelect").change(function () {
        sendSingleCGICmd("camera", "PictureEffect", $("#pictureEffectSelect").val());
    });
    $("#_2dnrSelect").change(function () {
        sendSingleCGICmd("imaging", "NoiseReduction2DLevel", $("#_2dnrSelect").val());
    });
    $("#_3dnrSelect").change(function () {
        sendSingleCGICmd("imaging", "NoiseReduction3DLevel", $("#_3dnrSelect").val());
    });
    $("#imageModeSelect").change(function () {
        sendSingleCGICmd("imaging", "ImageMode", $("#imageModeSelect").val());
        reloadImageMode();
    });
    $("#imageModeLoadSelect").click(function () {
        sendSingleCGICmd("imaging", "ImageModeLoad", "on");
        reloadImageMode();
    });
    connectButtonToInput("#hueMinusButtonInput", "#huePlusButtonInput", "#hueTextInput",
        cameraSettings, "ColorHue", 0, 15, 1, 1, null);
    connectButtonToInput("#gammaMinusButtonInput", "#gammaPlusButtonInput", "#gammaTextInput",
        cameraSettings, "GammaLevel", 0, 3, 1, 1, null);
    connectButtonToInput("#brightnessMinusButtonInput", "#brightnessPlusButtonInput", "#brightnessTextInput",
        cameraSettings, "DigitalBrightLevel", 0, 15, 1, 1, null);
    connectButtonToInput("#saturationMinusButtonInput", "#saturationPlusButtonInput", "#saturationTextInput",
        cameraSettings, "ColorSaturation", 0, 15, 1, 1, null);
    connectButtonToInput("#sharpnessMinusButtonInput", "#sharpnessPlusButtonInput", "#sharpnessTextInput",
        cameraSettings, "DetailLevel", 0, 14, 1, 1, null);
}

function openLiveview() {
    $("#DivMainPage").load("./page/liveview.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        liveviewOnload();
        tabPage();
        if (cameraSettings.ViewerMode != 0) {
            $("#A_tabPicture").hide();
        }
        if (cameraSettings.ModelName == "CV420e") {
            document.getElementById("Label_AFMF").style.visibility = "hidden";
            $(".switch_afmf").hide();
            document.getElementById("Label_FocusPlus").style.visibility = "hidden";
            $("#focusNearButton").hide();
            document.getElementById("Label_FocusMinus").style.visibility = "hidden";
            $("#focusFarButton").hide();
            $("#TD_IrisLabel").hide();
            $("#TD_IrisFunction").hide();
            $("#A_tabFocus").hide();
            $("#A_tabPTZ").hide();
            $("#Tr_DigitalZoom").show();
        }
        $.ajax({
            url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system&inqjs=camera&inqjs=imaging&inqjs=presetposition&inqjs=ptzf&inqjs=ndi",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                $("#cameraIDLabel").text(cameraSettings.CameraName);
                $("#locationLabel").text(cameraSettings.Location);

                // Home
                $("#presetInput").change(function () {
                    filterNumberInRange(this, 0, 255);
                });
                $("#presetRecallButton").on('click', function () {
                    sendSingleCGICmd("presetposition", "PresetCall", $("#presetInput").val());
                    $("#presetInput").val("");
                });
                $("#presetStoreButton").on('click', function () {
                    sendSingleCGICmd("presetposition", "PresetSet", $("#presetInput").val());
                    $("#presetInput").val("");
                });
                ActivatePanTiltElement();
                ActivateZoomBtnElements();
                ActivateManualFocusControl();
                var zoomPos = parseInt(cameraSettings.AbsolutePTZF.split(',')[2], 16);
                if (cameraSettings.ModelName == "CV420e") {
                    $("#digitalZoomChkbox").prop("checked", (cameraSettings.ZoomMode == "pixel") ? false : true);
                    if (cameraSettings.Resolution.indexOf("2160p") >= 0) {
                        $("#digitalZoomChkbox").prop("disabled", true);
                    }
                    if (cameraSettings.ZoomMode == "pixel") {
                        $("#zoomBarRangeInput").val(parseInt((zoomPos - 0x4000) * 300 / (0x6000 - 0x4000)));
                    } else {
                        $("#zoomBarRangeInput").val(parseInt((zoomPos - 0x4000) * 300 / (0x7AC0 - 0x4000)));
                    }
                    $("#digitalZoomChkbox").on('click', sendZoomMode);
                } else {
                    if (cameraSettings.DZoomLimit == "x1") {
                        $("#zoomBarRangeInput").val(parseInt(zoomPos * 300 / 0x4000));
                    } else {
                        $("#zoomBarRangeInput").val(parseInt(zoomPos * 300 / 0x7AC0));
                    }
                }
                lastZoomSliderValue = -1;
                $("#focusModeCheckboxInput").prop("checked", autoManual2BoolMap.get(cameraSettings.FocusMode));
                $("#focusModeCheckboxInput").change(function () {
                    var focusMode = ($('#focusModeCheckboxInput').is(':checked') == true) ? "auto" : "manual";
                    sendSingleCGICmd("camera", "FocusMode", focusMode);
                    updateFocusMode();
                });

                if (cameraSettings.OutputSource == "ndi" || cameraSettings.OutputSource == "hdmi+ndi") {
                    $("#nativeBtn").hide();
                    $("#dmsloader").hide();
                } else {
                    playVideo();
                    $("#nativeBtn").on('click', function () {
                        stopJpegVideo();
                        playJpegVideoFull();
                    });
                    $("#closeNativeBtn").on('click', function () {
                        stopJpegVideoFull();
                        playJpegVideo();
                    });
                }

                // Exposure
                updateExposurePageSelect();
                updateExposurePageValue();
                updateExposureMode();
                // White Balance
                updateWhiteBalancePageSelect();
                updateWhiteBalancePageValue();
                updateWhiteBalanceMode();
                // Focus
                updateFocusPageSelect();
                updateFocusPageValue();
                updateFocusMode();
                // Mirror
                updateMirrorPageValue();
                // PTZ
                updatePtzPageSelect();
                updatePtzPageValue();
                updatePanTiltLimit();
                // Picture
                updatePicturePageSelect();
                updatePicturePageValue();
                updateImageMode();

                activateExposurePageElements();
                activateWhiteBalancePageElements();
                activateFocusPageElements();
                activateMirrorPageElements();
                activatePTZPageElements();
                activatePicturePageElements();
            }
        });
    });
}
